<?php
	/*
	* GMapFP Plugin for Page Builder CK
	* Version J3_3
	* Creation date: Janvier 2018
	* Author: Fabrice4821 - www.gmapfp.org
	* Author email: webmaster@gmapfp.org
	* License GNU/GPL
	*/

defined('_JEXEC') or die;

$input = JFactory::getApplication()->input;
$id = $input->get('ckid', '', 'string');

$com_gmapfp_exist = file_exists(JPATH_ADMINISTRATOR.'/components/com_gmapfp/models/gmapfps.php');
if ($com_gmapfp_exist) {

	// build list of categories
	$categories = JHtml::_('category.options', 'com_gmapfp');
	array_unshift($categories, JHTML::_('select.option', '', '-- '.'toutes les catégories'.' --' ));
	$lists['catid_filtre'] = JHTML::_('select.genericlist', $categories, 'filtre_gmapfpcatid', 'onchange="change_gmapfpcatid();" class="input" ', 'value', 'text');
}
?>
<div id="elementscontainer">
	<div class="menulink" tab="tab_map"><?php echo JText::_('PLG_PAGEBUILDERCK_GMAPFP_MAP_EDITION'); ?></div>
	<div class="tab menustyles ckproperty" id="tab_map">
		<div class="layoutinfos">
			<div class="layoutinfostitle"><?php echo JText::_('PLG_PAGEBUILDERCK_GMAPFP_MAP_INFOS'); ?></div>
			<div class="layoutinfosdesc"><?php echo JText::_('PLG_PAGEBUILDERCK_GMAPFP_MAP_INFOS_DESC'); ?></div>
		</div>

		<div class="clr"></div>

		<div class="menustylesblocktitle"><?php echo JText::_('JGLOBAL_USE_GLOBAL') ?></div>
		<div class="menustylesblockaccordion">
			<div style="text-align:left;">
				<div class="menupanetitle"><?php echo JText::_('JCATEGORIES'); ?></div>
				<select id="gmapfpcatid" name="gmapfpcatid[]" onchange="update_places()" class="input-xxlarge inputbox" style="width:280px; height:80px;" multiple="">
				</select>
				<div id="sablier" style="float:right;">
					<img style="height:72px;" src="<?php echo JUri::root(true); ?>/plugins/pagebuilderck/gmapfp_map/assets/images/gif-load.gif" />
				</div>
				<div class="menupanetitle"><?php echo JText::_('PLG_PAGEBUILDERCK_GMAPFP_MAP_LIEUX'); ?></div>
				<?php echo $lists['catid_filtre']; ?>
				<select id="gmapfpplaceid" name="gmapfpplaceid[]" onchange="update_places()" class="input-xxlarge inputbox" style="width:280px; height:80px;" multiple="">
				</select>
				<div class="menupanetitle"><?php echo JText::_('PLG_PAGEBUILDERCK_GMAPFP_MAP_KML'); ?></div>
				<input class="inputbox" type="text" value="" name="gmapfpkml" id="gmapfpkml" size="7" style="width:45%; min-width: 200px;" placeholder="<?php echo JText::_('PLG_PAGEBUILDERCK_GMAPFP_MAP_KML_HOLDER'); ?>" />
			</div>
			<div class="menupanetitle"><?php echo JText::_('CK_DIMENSIONS'); ?></div>
			<div style="text-align:left;clear:both;">
				<div style="float:left;text-align:right;margin:5px 5px 0 0;line-height: 15px;;"><?php echo JText::_('CK_WIDTH'); ?></div><div style="float:left;text-align:right;margin:5px 5px 0 0;"><img src="<?php echo $this->imagespath; ?>width.png" width="15" height="15" align="top" /></div><div style="float:left;"><input class="inputbox" onchange="update_gmapfp_params();" type="text" name="gmapfpwidth" id="gmapfpwidth" size="2" value="100%" style="" /></div><div style="float:left;text-align:left;margin-left:3px;"></div>							
				<div style="float:left;text-align:right;margin:5px 5px 0 10px;line-height: 15px;;"><?php echo JText::_('CK_HEIGHT'); ?></div><div style="float:left;text-align:right;margin:5px 5px 0 0;"><img src="<?php echo $this->imagespath; ?>height.png" width="15" height="15" align="top" /></div><div style="float:left;"><input class="inputbox" onchange="update_gmapfp_params();" type="text" name="gmapfpheight" id="gmapfpheight" size="2" value="480px" style="" /></div><div style="float:left;text-align:left;margin-left:3px;"></div>
				<div style="float:left;text-align:right;margin:5px 5px 0 10px;line-height: 15px;;"><?php echo JText::_('CK_ZOOM'); ?></div>
				<div style="float:left;text-align:right;margin:5px 5px 0 0;">
					<img src="<?php echo $this->imagespath; ?>magnifier.png" width="15" height="15" align="top" />
				</div>
				<div style="float:left;">
					<select class="input-large inputbox" onchange="update_gmapfp_params();" style="width:210px;" name="gmapfpzoom" id="gmapfpzoom" value="0" >
						<option value="0"><?php echo JText::_('PLG_PAGEBUILDERCK_GMAPFP_MAP_AUTO'); ?></option>
						<option value="1">1</option>
						<option value="2">2</option>
						<option value="3">3</option>
						<option value="4">4</option>
						<option value="5">5</option>
						<option value="6">6</option>
						<option value="7">7</option>
						<option value="8">8</option>
						<option value="9">9</option>
						<option value="10">10</option>
						<option value="11">11</option>
						<option value="12">12</option>
						<option value="13">13</option>
						<option value="14">14</option>
						<option value="15">15</option>
						<option value="16">16</option>
						<option value="17">17</option>
						<option value="18">18</option>
					</select>
				</div>
				<div style="float:left;text-align:left;margin-left:3px;"></div>
				<div class="clr"></div>
			</div>
			<div class="clr"></div>
		</div>
		<div class="menustylesblocktitle"><?php echo JText::_('JGLOBAL_FIELDSET_ADVANCED') ?></div>
		<div class="menustylesblockaccordion">
			<div class="menupanetitle"><?php echo JText::_('PLG_PAGEBUILDERCK_GMAPFP_MAP_ITIN'); ?></div>
			<div style="text-align:left;">
				<select class="input-large inputbox" style="width:210px;" name="gmapfpitin" id="gmapfpitin" value="8" >
					<option value="0"><?php echo JText::_('JOPTION_USE_DEFAULT') ?></option>
					<option value="1"><?php echo JText::_('JSHOW') ?></option>
					<option value="2"><?php echo JText::_('JHIDE') ?></option>
				</select>
			</div>
			<div class="clr"></div>
		</div>
	</div>
	<div class="menulink" tab="tab_blocstyles"><?php echo JText::_('CK_STYLES'); ?></div>
	<div class="tab menustyles ckproperty" id="tab_blocstyles">
		<?php echo $this->menustyles->createBlocStyles('bloc', 'map', '') ?>
	</div>
</div>
<div class="clr"></div>
<script language="javascript" type="text/javascript">
function ckLoadEditionPopup() {
	var focus = $ck('.editfocus');
	$ck('#previewareabloc .ckstyle').html(focus.find('.ckstyle').html());
	upload_gmapfpcatid()
	ckFillEditionPopup(focus.attr('id'));
}

function update_gmapfp_params() {
	var focus = $ck('.editfocus');
	
	new_width = $ck("#gmapfpwidth").val();
	new_height = $ck("#gmapfpheight").val();
	
	$ck('#' + focus.attr('id') + ' img').css('height', new_height);
	$ck('#' + focus.attr('id') + ' img').css('width', new_width);

}

function ckBeforeSaveEditionPopup() {
	var focus = $ck('.editfocus');

	focus.find('.ckstyle').html($ck('#previewareabloc .ckstyle').html());
	ckSaveEditionPopup(focus.attr('id'));
	ckCloseEditionPopup();
}

function update_places() {
	var cat_select = $ck("#gmapfpcatid option:selected");
	var places_select = $ck("#gmapfpplaceid option:selected");
	if (cat_select.length > 0) {
		var cat_ids = [];
		$ck.each(cat_select.valueOf(), function (index, cat_lieu_id) {
			cat_ids[index] = cat_lieu_id.value;
		});
		get_place_cat_info(cat_ids);
	} else if (places_select.length > 0) {
		var place_ids = [];
		$ck.each(places_select.valueOf(), function (index, cat_lieu_id) {
			place_ids[index] = cat_lieu_id.value;
		});
		get_place_info(place_ids);
	} else {
		//efface tout
		$ck(".gmapfpck ul li").remove();
	}
}

function get_place_info(value) {
	var focus = $ck('.editfocus');
	$ck('#' + focus.attr('id') + ' img').attr('place_catid', '');
	$ck('#' + focus.attr('id') + ' img').attr('place_id', value);
	return false;	
}
 
function get_place_cat_info(value) {
	var focus = $ck('.editfocus');
	$ck('#' + focus.attr('id') + ' img').attr('place_id', '');
	$ck('#' + focus.attr('id') + ' img').attr('place_catid', value);
	return false;	
}
		var ids = new Array();

function FillGMapFPSelection(id) {
	var focus = $ck('.editfocus');
	var cat = $ck('#' + focus.attr('id') + ' img').attr('place_catid');
	var ids = new Array();
	if (cat) {
		cat = cat.split(',');
		$ck('#gmapfpcatid').val(cat);
	} else {
		ids = $ck('#' + focus.attr('id') + ' img').attr('place_id');
		if (ids) {
			ids = ids.split(',');
			$ck('#gmapfpplaceid').val(ids);
		}
	}
	update_gmapfp_params();
	$ck('#sablier').fadeOut("fast");
}

function change_gmapfpcatid() {    
	$ck('#sablier').fadeIn("fast");
	var value = $ck('#filtre_gmapfpcatid option:selected').val();    
	var request = {
					'option' : 'com_ajax',
					'plugin' : 'getgmapfpdatas',
					'cmd'    : 'update_places',
					'data'   : value,
					'format' : 'json'
				};	
	$ck.ajax({
			type   : 'POST',
			data   : request,
			success: function (response) {
				// console.log(response);
				if(response.data){
					var result = '';
					$ck("#gmapfpplaceid").empty();
					$ck.each(response.data[0], function (index, lieu) {
						$ck("#gmapfpplaceid").append($ck("<option></option>").attr("value", lieu['value']).text(lieu['text']));
					});
					var focus = $ck('.editfocus');
					FillGMapFPSelection(focus.attr('id'));
				} else {
					$ck('.status').html(response);
				}
			},
			error: function(response) {
				var data = '',
					obj = $ck.parseJSON(response.responseText);
				for(key in obj){
					data = data + ' ' + obj[key] + '<br/>';
				}
				$ck('.status').html(data);
	        }
		});
	return false;	
};

function upload_gmapfpcatid() {    
	var request = {
					'option' : 'com_ajax',
					'plugin' : 'getgmapfpdatas',
					'cmd'    : 'get_place_cat',
					'data'   : '',
					'format' : 'json'
				};	
	$ck.ajax({
			type   : 'POST',
			data   : request,
			success: function (response) {
				// console.log(response);
				if(response.data){
					var result = '';
					$ck("#gmapfpcatid").empty();
					$ck.each(response.data[0], function (index, lieu) {
						$ck("#gmapfpcatid").append($ck("<option></option>").attr("value", lieu['value']).text(lieu['text']));
					});
					change_gmapfpcatid();
				} else {
					$ck('.status').html(response);
				}
			},
			error: function(response) {
				var data = '',
					obj = $ck.parseJSON(response.responseText);
				for(key in obj){
					data = data + ' ' + obj[key] + '<br/>';
				}
				$ck('.status').html(data);
	        }
		});
	return false;	
};
</script>
<style type="text/css">

</style>