<?php
	/*
	* ContactMap Component Google Map for Joomla! 3.x
	* Version J3.18F
	* Creation date: Novembre 2017
	* Author: Fabrice4821 - www.gmapfp.org
	* Author email: webmaster@gmapfp.org
	* License GNU/GPL
	*/

defined('_JEXEC') or die();

class ContactMapsModelContactMap extends JModelLegacy
{
    function __construct() 
    {
        parent::__construct(); 
		$app = JFactory::getApplication('site');
		if ($app->getName()=='site') {
			$params = $app->getParams();
		} else {
			$params = JComponentHelper::getParams('com_contactmap'); 
		}
		
        $this->_catid = JRequest::getVar('catid', $params->get('catid', 0), '', 'int'); 
        $this->_id = JRequest::getVar('id', 0, '', 'int'); 
        $this->_perso = JRequest::getVar('id_perso', 0, '', 'int'); 

        $this->_total   = null; 
        $this->_result  = null; 
        $this->_result2 = null; 
        $this->_result_personnalisation = null; 
        $this->_num_marqueurs = 0;
	}
	
	public function setId($id)
	{
		$this->_id = $id;
	}
		
	function init_header()
	{
		$app = JFactory::getApplication('site');
		$params = $app->getParams('com_contactmap');
		$doc = JFactory::getDocument();

        $lang = JFactory::getLanguage(); 
        $tag_lang=(substr($lang->getTag(),0,2)); 
         
		if (file_exists(JPATH_SITE.'/components/com_gmapfp/helpers/define.php')) {
			include_once(JPATH_SITE.'/components/com_gmapfp/helpers/define.php');
			Define_ModelGMapFP::define_gmapfp(0, array('LIGHTBOX', 'APIV3'));
		} else {
			$lang = JFactory::getLanguage(); 
			$tag_lang=(substr($lang->getTag(),0,2)); 

			$doc->addCustomTag( '<link rel="stylesheet" type="text/css" href="'.JURI::base().'components/com_contactmap/floatbox/floatbox.css" />');
			$doc->addCustomTag( '<script type="text/javascript" src="'.JURI::base().'components/com_contactmap/floatbox/floatbox.js"></script>');

			$https = "";
			if ((isset($_SERVER['HTTPS']) && !empty($_SERVER['HTTPS']) && (strtolower($_SERVER['HTTPS']) != 'off')) OR (isset($_SERVER['HTTP_X_FORWARDED_PROTO']) && !empty($_SERVER['HTTP_X_FORWARDED_PROTO']) && $_SERVER['HTTP_X_FORWARDED_PROTO'] == 'https')) $https = "s";

			$doc->addCustomTag( '<meta name="viewport" content="initial-scale=1.0, user-scalable=no" />'); 
			$doc->addCustomTag( '<script type="text/javascript" src="http'.$https.'://maps.google.com/maps/api/js?language='.$tag_lang.'&key='.$params->get('gmapfp_google_key').'"></script>'); 
		}

		$doc->addCustomTag( '<link rel="stylesheet" href="'.JURI::base().'components/com_contactmap/views/contactmap/contactmap.css" type="text/css" />'); 
        $doc->addCustomTag( '<link rel="stylesheet" href="'.JURI::base().'components/com_contactmap/views/contactmap/contactmap2.css" type="text/css" />'); 
		$doc->addCustomTag( '<script type="text/javascript" src="'.JURI::base().'components/com_contactmap/libraries/contactmap.js"></script>'); 
   }

    function _getQuery()
    {
        $db     = JFactory::getDBO();
		$tag = JFactory::getLanguage()->getTag();
        
		$mainframe = JFactory::getApplication(); 
		$Itemid    = JRequest::getInt('Itemid'); 
		$option    = JRequest::getCMD('option'); 
        $params = clone($mainframe->getParams('com_contactmap'));
        $tri = $params->get('orderby_pri');
		$user	= JFactory::getUser();
		$groups	= implode(',', $user->getAuthorisedViewLevels());

        switch ($tri) {
        case 'alpha' :
            $order = "\n ORDER BY a.name";
            break;
        case 'ralpha' :
            $order = "\n ORDER BY a.name DESC";
            break;
        case 'ville' :
            $order = "\n ORDER BY a.suburb, a.name";
            break;
        case 'rville' :
            $order = "\n ORDER BY a.suburb DESC, a.name DESC";
            break;
        case 'pays' :
            $order = "\n ORDER BY a.country, a.suburb, a.name";
            break;
        case 'rpays' :
            $order = "\n ORDER BY a.country DESC, a.suburb DESC, a.name DESC";
            break;
        default :
            $order = "\n ORDER BY a.ordering";
            break;
        }

        $select = 'a.*, cm.*, m.name AS m_name, m.url, cc.access as category_access, cc.title as category_name, cc.description as cat_description,'
        . ' CASE WHEN CHAR_LENGTH(a.alias) THEN CONCAT_WS(\':\', a.id, a.alias) ELSE a.id END as slug, '
        . ' CASE WHEN CHAR_LENGTH(cc.alias) THEN CONCAT_WS(\':\', cc.id, cc.alias) ELSE cc.id END AS catslug ';
        $from   = '#__contact_details AS a';

        $joins[] = 'INNER JOIN #__categories AS cc on cc.id = a.catid';
        $joins[] = 'LEFT OUTER JOIN #__contactmap_details AS cm on cm.contact_id = a.id';
        $joins[] = 'LEFT OUTER JOIN #__contactmap_marqueurs AS m on m.id = cm.marqueur_id';

		$wheres[] = 'a.access IN ('.$groups.')';
        $wheres[] = 'a.published = 1';
        $wheres[] = 'cc.published = 1';
        $wheres[] = 'cm.lat != ""';
        $wheres[] = 'cm.lng != ""';
		// Filter by language
		if ($mainframe->isSite() && $mainframe->getLanguageFilter()) {
			$wheres[] ='a.language in (' . $db->Quote($tag) . ',' . $db->Quote('*') . ')';
		}
		
        $user = JFactory::getUser();
        $aid = $user->get('aid', 0);
        
        if (!empty($this->_catid))
        {
			$_catids = $this->enfants_catid($this->_catid);
			foreach ($_catids as $_catid)
			{
				$wheresOr[] = 'a.catid = '.$_catid.'';
			}
			$wheres[] = '('.implode( "\n OR ", $wheresOr).')';
        };

        if (!empty($this->_id))
        {
            $wheres[] = 'a.id = '.$this->_id.'';
        };

        $query = "SELECT " . $select .
                "\n FROM " . $from .
                ' '. implode ( ' ', $joins ) .
                "\n WHERE " . implode( "\n  AND ", $wheres ).
                $order;

        // die(print_r($query));
		return $query;
    }

	function enfants_catid($id)
	{
		$app = JFactory::getApplication();
		$params = $app->getParams();

		$ids[] = $id;
		if ($params->get('recursive', 1)) {
			//renvoie tous les enfants de $id tri par parent et ordre alphabtique
			$count_ids = count($ids);
			
			for ($i = 0; $i < $count_ids; $i++) {
				if ($this->_enfant($ids[$i]))
					$ids = array_merge(array_slice($ids, 0, $i+1), $this->_enfant($ids[$i]), array_slice($ids, $i+1));
				$count_ids = count($ids);
			}
		}

		return $ids;
	}

	function _enfant($id)
	{
		$db	= JFactory::getDBO();
		$query = "SELECT id" .
				"\n FROM #__categories" .
				"\n WHERE parent_id = ".$id .
				"\n AND extension = 'com_contact'" .
				"\n AND published = true" .
				"\n ORDER BY title";
    	$db->setQuery( $query );
		$result = $db->loadColumn();
		return $result;
	}
	
    function getTotal()
    {
        // Lets load the content if it doesn't already exist
        if (empty($this->_total))
        {
            $query = $this->_getQuery();
            $this->_total = $this->_getListCount($query);
        }
        return $this->_total;
    }
    
    function getContactMapList()
    {
        if (empty($this->_result2))
        {
            $query  = $this->_getQuery();
            $this->_result2 = $this->_getList( $query );
        }
        return @$this->_result2;
    }
    
    function getView()
    {
        if (empty($this->_result)) 
        {
			$query  = $this->_getQuery();
			$this->_result = $this->_getList( $query );
        };
		if ($this->_result) {
			$map    = $this->getCarte($this->_result);
			return $map;
		} else
			return false;
    }
    
    function getCarte ($rows)
    {
    $this->init_header();
	
	//spcial pour ContactMap
    //contactmap_eventcontrol="0"
    $click_over=2;

	$mainframe = JFactory::getApplication(); 
	$doc = JFactory::getDocument();
    $language = JFactory::getLanguage();
    $language->load('com_contactmap');
    $config	= clone($mainframe->getParams('com_contactmap'));
    //spcial pour ContactMap
	if ($config->get('contactmap_photo_icon', 0)) $this->verif_icon($rows);


    //traitement des donnes de zoom
    $_layout = JRequest::getVar('layout', "", '', 'str');
    $zoom = "";
    if ($_layout == "item_carte") {
        if ((empty($this->_id))or($config->get('contactmap_zoom_lightbox_carte', 5)!=100)) {
            $zoom = $config->get('contactmap_zoom_lightbox_carte', 5);
        }else{
            $zoom = $rows[0]->zoom;
        };
    };
    if ($_layout == "print_article") {
        $zoom = $config->get('contactmap_zoom_lightbox_imprimer', 5);
    };
    if (($zoom == "") or ($zoom == 0)) {
        $zoom = $config->get('contactmap_zoom', 5);
    };
    $Zmap = $zoom;
	
    $flag = JRequest::getVar('flag', 0, '0', 'int');
    $itemid = JRequest::getVar('Itemid', 0, '', 'int');

    if (empty($num)) { $num = ''; };

//Cration des marqueurs
	//creation de l'infowindow
    //si on_click
    if ($_layout == "map") {
        $create_infowindow='
        function attachinfowindow(marker,place,i){
            google.maps.event.addListener(marker, \'click\', function(e) {
                fb.start({ href:place[5], rev: "width:70% height:70% scrolling:yes innerBorder:1" });
            });
            infowindow[i] = new google.maps.InfoWindow({
                content: place[4]
            });
			google.maps.event.addListener(marker, \'mouseover\', function(e) {
				infowindow[num_open].close(carteContactMap'.$num.',marker);
				infowindow[i].setZIndex(++infowindowLevel);
				infowindow[i].open(carteContactMap'.$num.',marker);
				num_open = i;
			});
        }';
        $plus_detail = JTEXT::_("COM_CONTACTMAP_CLICK_SEND_MAIL");
    }else{
        $create_infowindow='function attachinfowindow(marker,place,i){
            infowindow[i] = new google.maps.InfoWindow({
                content: place[4]
            });
            google.maps.event.addListener(marker, \'click\', function(e) {
                infowindow[i].setZIndex(++infowindowLevel);
                infowindow[i].open(carteContactMap'.$num.',marker);
            });
        }';
        $plus_detail = "";

    }
	//Centrage auto et zoom auto
    if ($config->get('contactmap_auto', 1))
        {$centrageauto='carteContactMap.setCenter(bounds_ContactMap.getCenter());';}
    else
        {$centrageauto='';}
    
    if (!$Zmap) {
		$Zauto='carteContactMap.fitBounds(bounds_ContactMap);';}
    else
        {$Zauto='';}
    
	//cration du marqueur
	$create_marker = 'create_carteContactMap.prototype.addMarker = function 	(donnees){'
		.$create_infowindow
		.'	
	for (var i = 0; i < donnees.length; i++) {
		var place = donnees[i];
		hm=markerImage[i].height;
		lm=markerImage[i].width;
		image[i] = new google.maps.MarkerImage(markerImage[i].src,
			// This marker is 20 pixels wide by 32 pixels tall.
			new google.maps.Size(lm, hm),
			// The origin for this image is 0,0.
			new google.maps.Point(0,0),
			// The anchor for this image is the base of the flagpole at 0,32.
			new google.maps.Point((lm/2), hm));

		var maLatLng = new google.maps.LatLng(place[1], place[2]);
		bounds_ContactMap.extend(maLatLng);
		contactmap_marker_map[i] = new google.maps.Marker({
			map: carteContactMap'.$num.',
			position: maLatLng,
			title: place[7],
			icon: image[i],
			zIndex: place[3]
		});
		attachinfowindow(contactmap_marker_map[i],place,i);
	}
	'
	.$centrageauto
	.$Zauto
	.'
};

';

    $VariableDirection='';
    $DeclareDirection='';
    if ($config->get('contactmap_itineraire', 0)) {
        $VariableDirection='var directionDisplay;
            var directionsService = new google.maps.DirectionsService();';
        $DeclareDirection='
            directionsDisplay = new google.maps.DirectionsRenderer();
            directionsDisplay.setMap(carteContactMap'.$num.');
                directionsDisplay.setPanel(document.getElementById("contactmap_directions'.$num.'"));';
    }
    $MapVariables=' var map'.$num.';
            var markerImage = new Array();
            var places  = [];
            var image   = new Array();
            var infowindowLevel = 0;
            '.$VariableDirection.'
    ';

//affichage de plus de dtail : Panoramino, Wiki, Youtube, ...
	$control ="";
	$event_panoramino = "";
    if ($config->get('contactmap_plus_info', 1)){
		$control = '
		  var contactmap_moreControlDiv = document.createElement(\'DIV\');
		  var contactmap_moreControl = new contactmap_MoreControl(carteContactMap'.$num.', contactmap_moreControlDiv);
		  contactmap_moreControlDiv.index = 1;
		  carteContactMap'.$num.'.controls[google.maps.ControlPosition.TOP_RIGHT].push(contactmap_moreControlDiv);
		';

	//photos Panoramino
	$event_panoramino = "
		contactmap_activated_panoramino = false;
		contactmap_nbre_photos_panoramino = 20;
		google.maps.event.addListener(carteContactMap, 'idle', function() {
		  if (contactmap_activated_panoramino) {contactmap_loadPhotosPanoramino();}
		});
	";
	}
    
//choix des options d'affichage de la carte
//bar de zoom 3D (ANDROID,SMALL,ZOOM_PAN)
    if ($config->get('contactmap_mapcontrol', 1)) 
        {$ControlOption ='zoomControl: true, panControl: true,
                  navigationControlOptions: {style: google.maps.NavigationControlStyle.ZOOM_PAN},';}
    else
        {$ControlOption ='zoomControl: false, panControl: false,';};
//Affichage de l'chelle
    if ($config->get('contactmap_scalecontrol', 1)) 
        {$ControlOption.='
              scaleControl: true,';}
    else
        {$ControlOption.='
              scaleControl: false,';};
//activation du zoom par molette de la sourie
    if ($config->get('contactmap_mousewheel', 1)) 
        {$ControlOption.='
              scrollwheel: true,';}
    else
        {$ControlOption.='
              scrollwheel: false,';};
              
//affichage streetView
    $HeightPano=$config->get('contactmap_height_sv', 300);
    $streeview='';
    if ($config->get('contactmap_streetView', 1)) 
        { $ControlOption.='
              streetViewControl: true,';
		$streeview = '
			var optionstreetview'.$num.' = {
				//position: mycentre,
				enableCloseButton: true,
				imageDateControl: true,
				visible: false,
				pov: {
					heading: 34,
					pitch: 10,
					zoom: 1
				}
			};
		';
        $streeview.='
            panorama = new  google.maps.StreetViewPanorama(document.getElementById("pano"), optionstreetview'.$num.');
                carteContactMap.setStreetView(panorama);
                panorama.setVisible(false);';
        $streeview.='
            google.maps.event.addListener(panorama, \'visible_changed\', function(mEvent) {
                if(panorama.getVisible()) {
                    var maDiv = document.getElementById("pano");
                    maDiv.style.height = "'.$HeightPano.'px";
                } else {
                    var maDiv = document.getElementById("pano");
                    maDiv.style.height = "1px";
                };
            });';}
    else
        { $ControlOption.='
              streetViewControl: false,';};

//insertion du fichier kml
    $geo_xml='';
    if ($config->get('contactmap_geoXML')) 
        { $geo_xml= '
            var ctaLayer = new google.maps.KmlLayer(\''.$config->get('contactmap_geoXML').'\');
                ctaLayer.setMap(carteContactMap'.$num.');';};

//insertion du traffic
    $traffic='';
    if ($config->get('contactmap_traffic', 0)) { 
		$traffic= '
			contactmap_trafficLayer = new google.maps.TrafficLayer();
			contactmap_trafficLayer.setMap(carteContactMap'.$num.');
			contactmap_trafficLayer.enabled = true;';
	} else {
		$traffic= '
			contactmap_trafficLayer = new google.maps.TrafficLayer();
			contactmap_trafficLayer.enabled = false;';
	};

$mapTypeId=array();
//affichage bouton carte hybride
    if ($config->get('contactmap_hybrid', 1)) 
        { $mapTypeId[]='google.maps.MapTypeId.HYBRID';}
//affichage bouton carte normale
    if ($config->get('contactmap_normal', 1)) 
        { $mapTypeId[]='google.maps.MapTypeId.ROADMAP';}
//affichage bouton carte relief
    if ($config->get('contactmap_physic', 1)) 
        { $mapTypeId[]='google.maps.MapTypeId.TERRAIN';}
//affichage bouton carte satellite
    if ($config->get('contactmap_satellite', 1)) 
        { $mapTypeId[]='google.maps.MapTypeId.SATELLITE';}
    $mapTypeIds=implode( ",", $mapTypeId );
    $mapTypeIds='var types = ['.$mapTypeIds.'];';
//selection du type d'affichage des types de carte
    $MapTypeControlStyle='';
    if ($config->get('contactmap_vertical', 0)) 
        { $MapTypeControlStyle='style: google.maps.MapTypeControlStyle.DROPDOWN_MENU,';}

    $points = "places".$num." = [\n";
    $cnt2 = 0;
    foreach($rows as $row){
        if (($row->lat<>"")&&($row->lng<>"")) {
			if (($row->image)&&($config->get('contactmap_photo_icon'))) {
				$image = JURI::base().'images/contactmap/thumb_'.JFile::getName($row->image);
				$row->url =$image;
			}else if(empty($row->url)){
				$https = "";
				if ((isset($_SERVER['HTTPS']) && !empty($_SERVER['HTTPS']) && (strtolower($_SERVER['HTTPS']) != 'off')) OR (isset($_SERVER['HTTP_X_FORWARDED_PROTO']) && !empty($_SERVER['HTTP_X_FORWARDED_PROTO']) && $_SERVER['HTTP_X_FORWARDED_PROTO'] == 'https')) $https = "s";
				$row->url ="http".$https."://www.google.com/mapfiles/marker.png";
			}
	
			if ($cnt2) {$points.=',';};
			$points.='[\''.$row->url.'\'';
			$cnt2++;

            $image ='';
            if (@$row->image) {
                $image = JURI::base().$row->image;
                $image = "<img src=".$image." style='height: ".$config->get('contactmap_hauteur_img', 100)."px'>";
            }
            $points.= ','.$row->lat.','.$row->lng.',';
            $nom  = addslashes($row->name);
            
			if (!$config->get('target', 0)) {
				$map_link=JURI::base()."index.php?option=com_contact&view=contact&tmpl=component&id=".$row->id;
			}else{
				include_once (JPATH_SITE.'/components/com_contact/helpers/route.php');
				$map_link=ContactHelperRoute::getContactRoute(JURI::base()."index.php?option=com_contact&view=contact&id=".$row->id, $row->catid);
			};
			$choix=1;
            
            if (@$row->address)     {
                $adr    = addslashes($row->address)."<br />";
                $order  = array("\r\n", "\n", "\r");
                $adr    = str_replace( $order, '<br />', $adr );
                $adr    = str_replace( '<br>', '<br />', $adr );
            }else{
                $adr='';
            };
            if (@$row->postcode)    {$cp    = addslashes($row->postcode)."<br />";}else{$cp='';};
            if (@$row->suburb)      {$ville = addslashes($row->suburb)."<br />";}else{$ville='';};
            if (@$row->state)       {$dep   = addslashes($row->state)."<br />";}else{$dep='';};
            if (@$row->country)     {$pays  = addslashes($row->country)."<br />";}else{$pays='';};
            
$row->affichage = 0;
            switch ($row->affichage) {
            case 0: 
                $points.= ($this->_num_marqueurs+1000).", \"<div class='contactmap_marqueur' style='width:".$config->get('contactmap_width_bulle_contactmap', 400)."px'><span>".$nom."</span><br /><br />".$image."<table><table><tr><td>".$adr.$cp.$ville.$dep.$pays."</td></tr></table><tr><td>";
                $points.="</td></tr></table><br />".$plus_detail."</div>\",\"".$map_link."\",".$choix;
                break;
            case 1:
                $points.= ($this->_num_marqueurs+1000).", \"<div class='contactmap_marqueur' style='width:".$config->get('contactmap_width_bulle_contactmap', 400)."px'><span>".$nom."</span><br /><br />".$image."<table><tr><td>".$adr.$cp.$ville.$dep.$pays."</td></tr></table><br />".$plus_detail."</div>\",\"".$map_link."\",".$choix;
                break;
            case 2:
                $points.= ($this->_num_marqueurs+1000).", \"<div class='contactmap_marqueur' style='width:".$config->get('contactmap_width_bulle_contactmap', 400)."px';><span>".$nom."</span><br /><br />".$image;
                $points.="<br />".$plus_detail."</div>\",\"".$map_link."\",".$choix;
                break;
            default:
                $points.= ($this->_num_marqueurs+1000).", \"<div class='contactmap_marqueur' style='width:".$config->get('contactmap_width_bulle_contactmap', 400)."px';><span>".$nom."</span>";
                $points.="<br />".$plus_detail."</div>\",\"".$map_link."\",".$choix;
            }
            if (!((($config->get('contactmap_eventcontrol', 1)==1)AND($click_over==0))OR($click_over==1))){
                $points.=", \"".$nom."\"";
            };          
            $points.="]\n ";
            $this->_num_marqueurs++;
        }
    }
    $points.='];';
    
    $carte_choix='ROADMAP';
    if ($config->get('contactmap_choix_affichage_carte', 0)==2) { $carte_choix='SATELLITE';};
    if ($config->get('contactmap_choix_affichage_carte', 0)==3) { $carte_choix='HYBRID';};
    if ($config->get('contactmap_choix_affichage_carte', 0)==4) { $carte_choix='TERRAIN';};

    $gestion_erreur_direction='';
    if ($config->get('contactmap_itineraire', 0)) {
        $gestion_erreur_direction='GEvent.addListener(gdir'.$num.', "error", handleErrors'.$num.');';
    };
    
	$lat=$config->get('contactmap_centre_lat', 0);
	$lng=$config->get('contactmap_centre_lng', 0);
    
    $contactmap_script = '<script type="text/javascript"> 
		// <![CDATA[
        '.
        $MapVariables.
        '
		var carteContactMap;
		var infowindow = new Array();
		var num_open = 0;
		var contactmap_trafficLayer = null;
		var contactmap_trafficLayer_enabled = '.$config->get('contactmap_traffic', 0).';
		var ContactMap_moreControlText = Array("'.JText::_('COM_CONTACTMAP_MORE').'", "'.JText::_('COM_CONTACTMAP_TRAFFIC').'");

        function create_carteContactMap'.$num.'() {
            '.$mapTypeIds.'
            var myOptions'.$num.' = {
              zoom: '.$Zmap.',
              center: new google.maps.LatLng('.$lat.', '.$lng.'),
              '.$ControlOption.'
              mapTypeControlOptions: {
                '.$MapTypeControlStyle.'
                mapTypeIds: types
              },
              mapTypeId: google.maps.MapTypeId.'.$carte_choix.'
            };
            carteContactMap'.$num.' = new google.maps.Map(document.getElementById("map_canvas'.$num.'"),myOptions'.$num.');'
			.$control
            .$geo_xml
			.$event_panoramino
            .$traffic
            .$streeview
            .$DeclareDirection
        ."\n}\n\n"
		.$create_marker
        .$points."\n"
    ;
    
    if (empty($Hmap)) {$Hmap=$config->get('contactmap_height', 400);};
    $carte='';
    if (!empty($perso)) { $carte=$perso->intro_carte;};
    $carte.=
    '<div id="contactmap" style="width:100%; height:auto">';
    $carte.=
        '<div id="map_canvas'.$num.'" style="width:100%; height:'.$Hmap.'px"></div>';
    if ($config->get('contactmap_streetView', 1)) {
        $carte.=
         '<div id="pano" style="width:100%;"></div> ';
    }

            if (($config->get('contactmap_itineraire', 0)==1)) {
            $carte.='                   
                <p style="text-align:center;margin:2px 0;">&nbsp;</p>
                <form action="#" onsubmit="contactmap_CalculRoute(\''.$num.'\'); return false;" method="post" name="direction_form">
                        <div class="gmnoprint">
                        <legend>'.JText::_( 'COM_CONTACTMAP_DIRECTION' ).'</legend>
                        <p>
                            '.JText::_( 'COM_CONTACTMAP_DE' ).' : 
                            <select name="select_from'.$num.'" id="select_from'.$num.'">
                                <option value="">'.JText::_( 'COM_CONTACTMAP_CHOIX_DE' ).'</option>';
                                foreach($rows as $row) {
                                    $selected = '';
                                    if (isset($row->lat) && isset($row->lng) && !empty($row->lat) && !empty($row->lng)) {
                                        $value = $row->lat.','.$row->lng;
                                    } else {
                                        $value = @$row->country.' '.@$row->postcode.' '.@$row->suburb.' '.@$row->address;
                                    }
                                    $carte .= '<option value="'.$value.'" '.$selected.'>'.$row->name.'</option>';
                                }
                                $carte.='
                            </select>
                            '.JText::_( 'COM_CONTACTMAP_OU' ).'<input type="text" name="text_from'.$num.'" id="text_from'.$num.'" />
                        </p>
                            '.JText::_( 'COM_CONTACTMAP_VERS' ).' :
                            <select name="select_to'.$num.'" id="select_to'.$num.'">
                                <option value="">'.JText::_( 'COM_CONTACTMAP_CHOIX_VERS' ).'</option>';
                                foreach($rows as $row) {
                                    $selected = '';
                                    if (isset($row->lat) && isset($row->lng) && !empty($row->lat) && !empty($row->lng)) {
                                        $value = $row->lat.','.$row->lng;
                                    } else {
                                        $value = @$row->country.' '.@$row->postcode.' '.@$row->suburb.' '.@$row->address;
                                    }
                                    $carte .= '<option value="'.$value.'" '.$selected.'>'.$row->name.'</option>';
                                }
                                $carte.='
                            </select>
                            '.JText::_( 'COM_CONTACTMAP_OU' ).'<input type="text" name="text_to'.$num.'" id="text_to'.$num.'" />
                            <input type="submit" value='.JText::_( 'COM_CONTACTMAP_GO' ).' />
                        </div>
                        <div id="contactmap_directions'.$num.'"></div>
                <input type="hidden" name="direction" value="1" />
                </form>
                ';
            };
    $carte.='<\div>';
    $loadmarqueur = "
		function LoadMarqueur".$num."() {
			for(i = 0; i < places".$num.".length; i++) {
				markerImage[i] = new Image();
				markerImage[i].src = places".$num."[i][0];
			}
		}
	";
	
    // Charge la procdure d'init de la carte
    $doc->addCustomTag( $contactmap_script."
    ".$loadmarqueur."
	google.maps.event.addDomListener(window, 'load', LoadMarqueur".$num.");
	google.maps.event.addDomListener(window, 'load', initialise_contactmap".$num.");
	
	var tstContactMapFP".$num.";
	var tstIntContactMapFP".$num.";
	
	function ContactMapFP".$num."() {
		if (tstContactMapFP".$num.") {
			if (tstContactMapFP".$num.".offsetWidth != tstContactMapFP".$num.".getAttribute('oldValue')) {
				tstContactMapFP".$num.".setAttribute('oldValue',tstContactMapFP".$num.".offsetWidth);
				initialise_ContactMapFP".$num."();
			}
		}
	}

	function initialise_contactmap".$num."(){
		tstContactMapFP".$num." = document.getElementById('map_canvas".$num."');
		tstContactMapFP".$num.".setAttribute('oldValue',0);
		tstIntContactMapFP".$num." = setInterval('ContactMapFP".$num."()',500);
	}

	function initialise_ContactMapFP".$num."() {
		var maCarteContactMap= new create_carteContactMap;
		maCarteContactMap.addMarker(places);

	}		
			
	// ]]>
    </script>");

    return $carte;
    }
    function getlistville()
    {
        $wheres[] = 'published = 1';

        if (!empty($this->_catid))
        {
        	$_catids = $this->enfants_catid($this->_catid);
            $_catids = explode( ',', $_catids );
            foreach ($_catids as $_catid)
            {
                $wheresOr[] = 'catid = '.$_catid.'';
            }
            $wheres[] = '('.implode( " OR ", $wheresOr).')';
        };

        $query = 'SELECT DISTINCT suburb' .
                ' FROM #__contact_detail' .
                ' WHERE ' . implode( '  AND ', $wheres ).
                ' ORDER BY suburb';

        return $this->_getList( $query );
    }

    function getlistdepartement()
    {
        $wheres[] = 'published = 1';

        if (!empty($this->_catid))
        {
        	$_catids = $this->enfants_catid($this->_catid);
            $_catids = explode( ',', $_catids );
            foreach ($_catids as $_catid)
            {
                $wheresOr[] = 'catid = '.$_catid.'';
            }
            $wheres[] = '('.implode( " OR ", $wheresOr).')';
        };

        $query = 'SELECT DISTINCT state' .
                ' FROM #__contact_detail' .
                ' WHERE ' . implode( '  AND ', $wheres ).
                ' ORDER BY state';
        return $this->_getList( $query );
    }

    function getlistpays()
    {
        $wheres[] = 'published = 1';

        if (!empty($this->_catid))
        {
        	$_catids = $this->enfants_catid($this->_catid);
            $_catids = explode( ',', $_catids );
            foreach ($_catids as $_catid)
            {
                $wheresOr[] = 'catid = '.$_catid.'';
            }
            $wheres[] = '('.implode( " OR ", $wheresOr).')';
        };

        $query = 'SELECT DISTINCT country' .
                ' FROM #__contact_detail' .
                ' WHERE ' . implode( '  AND ', $wheres ).
                ' ORDER BY country';
        return $this->_getList( $query );
    }

    function getlistcategorie()
    {
        $wheres[] = 'published = 1';

        if (!empty($this->_catid))
        {
        	$_catids = $this->enfants_catid($this->_catid);
            $_catids = explode( ',', $_catids );
            foreach ($_catids as $_catid)
            {
                $wheresOr[] = 'id = '.$_catid.'';
            }
            $wheres[] = '('.implode( " OR ", $wheresOr).')';
        };

        $user =& JFactory::getUser();
        $aid = $user->get('aid', 0);
        $wheres[] = 'access <= '.(int) $aid;

        $query = 'SELECT DISTINCT title' .
                ' FROM #__categories' .
                ' WHERE extension = "com_contact_details"' .
                ' AND ' . implode( '  AND ', $wheres ).
                ' ORDER BY title';
        return $this->_getList( $query );
    }

	function verif_icon($thumbs)
	{
		jimport('joomla.filesystem.file');
		jimport('joomla.filesystem.folder');
		
		$basePath = JPath::clean(JPATH_ROOT.'/images/contactmap');
		$buffer = "<html>\n<body bgcolor=\"#FFFFFF\">\n</body>\n</html>";
		if (!JFolder::exists($basePath)) {
			JFolder::create($basePath);
			JFile::write($basePath."/index.html", $buffer);
		}
		
		foreach ($thumbs as $thumb)
		{
            $image ='';
            if (@$thumb->image) {
				$filepath = JPath::clean(JPATH_ROOT.'/'.$thumb->image);
				$thumbpath = JPath::clean(JPATH_ROOT.'/images/contactmap/thumb_'.JFile::getName($thumb->image));
				if (!file_exists($thumbpath) and file_exists($filepath))
				{
					$image = new Resize_Image();
					$image->load($filepath);
					$image->resizeToHeight(32);
					$image->save($thumbpath);
					$image->destroy();
				}
            }
		}
	}
}

class Resize_Image {
   var $image;
   var $image_type;
 
   function destroy() {
   		imagedestroy($this->image);
   }
   
   function load($filename) {
      $image_info = getimagesize($filename);
      $this->image_type = $image_info[2];
      if( $this->image_type == IMAGETYPE_JPEG ) {
         $this->image = imagecreatefromjpeg($filename);
      } elseif( $this->image_type == IMAGETYPE_GIF ) {
         $this->image = imagecreatefromgif($filename);
      } elseif( $this->image_type == IMAGETYPE_PNG ) {
         $this->image = imagecreatefrompng($filename);
      }
   }
   function save($filename, $image_type=IMAGETYPE_JPEG, $compression=75, $permissions=null) {
      if( $image_type == IMAGETYPE_JPEG ) {
         imagejpeg($this->image,$filename,$compression);
      } elseif( $image_type == IMAGETYPE_GIF ) {
         imagegif($this->image,$filename);         
      } elseif( $image_type == IMAGETYPE_PNG ) {
         imagepng($this->image,$filename);
      }   
      if( $permissions != null) {
         chmod($filename,$permissions);
      }
   }
   function output($image_type=IMAGETYPE_JPEG) {
      if( $image_type == IMAGETYPE_JPEG ) {
         imagejpeg($this->image);
      } elseif( $image_type == IMAGETYPE_GIF ) {
         imagegif($this->image);         
      } elseif( $image_type == IMAGETYPE_PNG ) {
         imagepng($this->image);
      }   
   }
   function getWidth() {
      return imagesx($this->image);
   }
   function getHeight() {
      return imagesy($this->image);
   }
   function resizeToHeight($height) {
      $ratio = $height / $this->getHeight();
      $width = $this->getWidth() * $ratio;
      $this->resize($width,$height);
   }
   function resizeToWidth($width) {
      $ratio = $width / $this->getWidth();
      $height = $this->getheight() * $ratio;
      $this->resize($width,$height);
   }
   function scale($scale) {
      $width = $this->getWidth() * $scale/100;
      $height = $this->getheight() * $scale/100; 
      $this->resize($width,$height);
   }
   function resize($width,$height) {
      $new_image = imagecreatetruecolor($width, $height);

		$white = imagecolorallocate($new_image, 255, 255, 255);
		$newtransparentcolor=imagecolortransparent( $new_image, $white );
		imagefill( $new_image, 0, 0, $newtransparentcolor );

      imagecopyresampled($new_image, $this->image, 0, 0, 0, 0, $width, $height, $this->getWidth(), $this->getHeight());
      $this->image = $new_image;   
   }      
}
?>
