<?php
	/*
	* ContactMap Component Google Map for Joomla! 3.x
	* Version J3.0
	* Creation date: Août 2014
	* Author: Fabrice4821 - www.gmapfp.org
	* Author email: webmaster@gmapfp.org
	* License GNU/GPL
	*/

defined('_JEXEC') or die;

class ContactMapModelMap extends JModelAdmin
{
	public $typeAlias = 'com_contactmap.detail';
	public $name = 'contact_id';
	public $id = null;

	public function getTable($type = 'Details', $prefix = 'ContactMapTable', $config = array())
	{
		return JTable::getInstance($type, $prefix, $config);
	}

	public function getForm($data = array(), $loadData = true)
	{
		// Get the form.
		$form = $this->loadForm('com_contactmap.detail', 'detail', array('control' => 'jform', 'load_data' => $loadData));

		if (empty($form))
		{
			return false;
		}

		return $form;
	}

	protected function loadFormData()
	{
		// Check the session for previously entered form data.
		$data = JFactory::getApplication()->getUserState('com_contactmap.edit.detail.data', array());

		if (empty($data))
		{
			$data = $this->getItem();
		}

		$this->preprocessData('com_contactmap.detail', $data);

		return $data;
	}
	
	public function getMarqueurs()
	{
		// Create a new query object.
		$db = $this->getDbo();
		$query = $db->getQuery(true);

		$params = JComponentHelper::getParams('com_contactmap');

		// Select the required fields from the table.
		$query->select(
			$this->getState(
				'list.select',
				'a.id AS id,' .
				'a.name AS name,' .
				'a.url AS url,' .
				'a.published AS state'
			)
		);

		$query->from($db->quoteName('#__contactmap_marqueurs') . ' AS a');
		$query->where('a.published = 1');
		$query->order('a.name ASC');

		$list = $this->_getList( $query );

		return $list;
	}
	
	public function getItem($pk = null)
	{
		$app = JFactory::getApplication();

		$pk = (!empty($pk)) ? $pk : (int) $app->input->getInt('id', $app->input->getInt('contact_id'));
		$table = $this->getTable();

		if ($pk > 0)
		{
			// Attempt to load the row.
			$return = $table->load($pk);

			// Check for a table object error.
			if ($return === false && $table->getError())
			{
				$this->setError($table->getError());
				return false;
			}
		}

		// Convert to the JObject before adding other data.
		$properties = $table->getProperties(1);
		$item = JArrayHelper::toObject($properties, 'JObject');

		if (property_exists($item, 'params'))
		{
			$registry = new JRegistry;
			$registry->loadString($item->params);
			$item->params = $registry->toArray();
		}
		
		if (empty($item->contact_id)) $item->contact_id = $pk;

		return $item;
	}
	
	public function validate($form, $data, $group=null)
	{
		return $data;
	}
	
	public function save($data)
	{
		$app = JFactory::getApplication();
		$table = $this->getTable();

		$data['contact_id'] = $app->input->getInt('id');
		$this->id = $data['contact_id'];
		
		$query = $this->_db->getQuery(true);
		$query->select($this->_db->quoteName('contact_id'));
		$query->from($this->_db->quoteName('#__contactmap_details'));
		$query->where($this->_db->quoteName('contact_id') . ' = '. $this->_db->quote((int) $data['contact_id']));
		$this->_db->setQuery( $query );
		$isnew = $this->_db->loadObject();

		if (empty($isnew)) {//is new
			$columns = array('contact_id', 'lat', 'lng', 'zoom', 'marqueur_id');
			$values = array($this->_db->quote((int) $data['contact_id']), $this->_db->quote($data['lat']), $this->_db->quote($data['lng']), $this->_db->quote($data['zoom']), $this->_db->quote($data['marqueur_id']));
			$query->clear()
				->insert($this->_db->quoteName('#__contactmap_details'))
				->columns($this->_db->quoteName($columns))
				->values(implode(',', $values));			
		} else {//update
			$fields = array(
				$this->_db->quoteName('lat') . ' = ' . $this->_db->quote($data['lat']),
				$this->_db->quoteName('lng') . ' = ' . $this->_db->quote($data['lng']),
				$this->_db->quoteName('zoom') . ' = ' . $this->_db->quote($data['zoom']),
				$this->_db->quoteName('marqueur_id') . ' = ' . $this->_db->quote($data['marqueur_id'])
			);
			$query->clear()
				->update($this->_db->quoteName('#__contactmap_details'))
				->set($fields)
				->where($this->_db->quoteName('contact_id') . ' = ' . $this->_db->quote((int) $data['contact_id']));
		}
		$this->_db->setQuery($query);
		$this->_db->query();

		// Clean the cache.
		$this->cleanCache();
		return true;
	}
	
	public function getState($property = null, $default = null)
	{
		if ($property == "map.id") return $this->id;
		
		if (!$this->__state_set)
		{
			// Protected method to auto-populate the model state.
			$this->populateState();

			// Set the model state set flag to true.
			$this->__state_set = true;
		}

		return $property === null ? $this->state : $this->state->get($property, $default);
	}
}
