	/*
	* GMapFP Plugin Google Map for GMapFP 4.x
	* Version J4_6F
	* Creation date: Janvier 2024
	* Author: Fabrice4821 - www.gmapfp.org
	* Author email: webmaster@gmapfp.org
	* License GNU/GPL
	*/
 
var marker = {};
var map_marker = {};
var infowindow = {};
var arrayOfLatLngs = [];

var params_map = null;

function show_map_infos(map_num) {
	eval('var map = carteGMapFP' + map_num + ';');
	eval('var bounds = bounds_GMapFP' + map_num + ';');
	eval('map_marker = map_marker' + map_num + ';');
	eval('params_map = map_params' + map_num + ';');

	//creer la liste des marqueurs
	eval('datas_marqueurs = marqueurs_datas' + map_num + ';');
	var cles = Object.keys(datas_marqueurs);
	cles.forEach(function(cle){
		var obj = datas_marqueurs[cle];
		var marqueur_url = obj.url;
		if (!marqueur_url.startsWith('//') && !marqueur_url.startsWith('http'))
			marqueur_url = GMapFP_baseURL + marqueur_url;
		var image_marker = new google.maps.MarkerImage(
			marqueur_url,
			new google.maps.Size(obj.marker_width, obj.marker_height),
			new google.maps.Point(0,0),
			new google.maps.Point(obj.centre_x, obj.centre_y)
		);
		var shape_marker = {
			coord: [0, 0, obj.marker_width, obj.marker_height],
			// type: \'rect\'
		};
		if (obj.url_shadow) {
			var shadow_url = obj.url_shadow;
			if (shadow_url && !shadow_url.startsWith('//') && !shadow_url.startsWith('http'))
				shadow_url = GMapFP_baseURL + shadow_url;
			var shadow_marker = new google.maps.MarkerImage(
				shadow_url,
				new google.maps.Size(obj.shadow_width, obj.shadow_height),
				new google.maps.Point(0,0),
				new google.maps.Point(obj.centre_x, obj.centre_y)
			);
			marker[obj.id] = new Object({
				icon: image_marker,
				shadow: shadow_marker,
				shape: shape_marker
			});
		} else {
			marker[obj.id] = new Object({
				icon: image_marker,
				shape: shape_marker
			});
		}
	});
	
	//creer les marqueurs
	eval('datas_map = map_datas' + map_num + ';');
	var cles = Object.keys(datas_map);
	cles.forEach(function(cle){
		var obj = datas_map[cle];
		var maLatLng = new google.maps.LatLng(obj.glat, obj.glng);
		// si pas de marqueur défini, marqueur de la catégorie
		if(!obj.marqueur || obj.marqueur == 0) {
			var cat_params = JSON.parse(obj.category_params);
			obj.marqueur = cat_params.default_marqueur_categories;
		}
		// si pas de marqueur défini, marqueur de la configuration
		if(obj.marqueur == 0)
			obj.marqueur = gmapfp_default_marker;

		if(marker[obj.marqueur]!= undefined) {
			map_marker[obj.id] = new google.maps.Marker({
				icon: marker[obj.marqueur].icon,
				shadow: marker[obj.marqueur].shadow,
				// shape: marker[obj.marqueur].shape,
			});
		} else {
			map_marker[obj.id] = new google.maps.Marker({
			});
		}
		map_marker[obj.id].setPosition(maLatLng);
		map_marker[obj.id].setZIndex(obj.id);
		map_marker[obj.id].setMap(map);
		map_marker[obj.id].catid = obj.catid;
		
		//centrage auto
		bounds.extend(maLatLng);
		
		var options = {
			item_id: obj.id,
			item_link: obj.link,
			item_article_id: obj.article_id,
			item_icon: obj.icon
		};
		map_marker[obj.id].options = options;
		
		//gestion de l'animation de la bubble
		infowindow[obj.id] = new google.maps.InfoWindow({
			content: make_bubble(obj),
			maxWidth: params_map.gmapfp_width_bulle_GMapFP
		});			
		if (params_map.gmapfp_eventcontrol >= 1) 
			map_marker[obj.id].addListener('mouseover', () => {
				infowindow[obj.id].open(map, map_marker[obj.id]);
			});
		if (params_map.gmapfp_eventcontrol == 1) 
			map_marker[obj.id].addListener('mouseout', () => {
				infowindow[obj.id].close(map, map_marker[obj.id]);
			});
		//gestion de l'affichage du lien du marqueur
		if (params_map.gmapfp_plus_detail == 1 && params_map.gmapfp_eventcontrol >= 1 && params_map.target != 4) 
			map_marker[obj.id].addListener('click', () => {
				infowindow[obj.id].close(map, show_marker_link(obj.id, map_num));
			});
	});
	
	function make_bubble(obj) {
		let image = {};
		let gmapfp_img_style = '';
		if (obj.img) {
			// console.log(obj.img);
			image = JSON.parse(obj.img);
			// console.log(image);
		}
		if (!image || !image.image) {
			image.image = "";
			gmapfp_img_style = 'style="display:none;"';
		}
		return eval(eval('bubble_datas' + map_num));
	}
}

function over_marker(id) {
	if (params_map.gmapfp_eventcontrol >= 1) infowindow[id].open(map, map_marker[id]);
}

function out_marker(id) {
	if (params_map.gmapfp_eventcontrol == 1) infowindow[id].close();
}
