<?php
	/*
	* GMapFP Component Google Map for Joomla! 4.0.x
	* Version J4_0_0F
	* Creation date: Octobre 2020
	* Author: Fabrice4821 - www.gmapfp.org
	* Author email: support@gmapfp.org
	* License GNU/GPL
	*/

defined('JPATH_BASE') or die;

use Joomla\CMS\Language\Text;
use Joomla\CMS\String\PunycodeHelper;
use Joomla\Registry\Registry;

$params	= clone $displayData['params'];
$item	= $displayData['item'];

if (isset($item->attribs)) {
	$attribs = new Registry($item->attribs);
	$params->merge($attribs);
}

?>
<dl class="com-gmapfp__address gmapfp-address" itemprop="address" itemscope itemtype="https://schema.org/PostalAddress">
	<?php if ($item->adresse || $item->adresse2 || $item->ville  || $item->departement || $item->pays || $item->codepostal) : ?>
		<dt>
			<span class="<?php echo $params->get('marker_class'); ?>">
				<?php echo $params->get('marker_address'); ?>
			</span>
		</dt>

		<?php 
			if ($item->adresse && $params->get('show_street_address',1)) : ?>
					<dd class="gmapfp-adresse" itemprop="streetAddress">
						<?php echo $item->adresse; ?>
					</dd>
			<?php endif;
			if ($item->adresse2 && $params->get('show_street_address',1)) : ?>
					<dd class="gmapfp-adresse2" itemprop="streetAddress">
						<?php echo $item->adresse2; ?>
					</dd>
			<?php endif;
			switch($params->get('cp_position')) {
				case 0:
					echo '<dd>';
						if ($item->codepostal && $params->get('show_postcode',1)) : ?>
							<span class="gmapfp-codepostal" itemprop="postalCode">
								<?php echo $item->codepostal; ?>
							</span>
						<?php endif;
						if ($item->ville && $params->get('show_suburb',1)) : ?>
							<span class="gmapfp-ville" itemprop="addressLocality">
								<?php echo $item->ville; ?>
							</span>
						<?php endif;
					echo '</dd>';
					break;
				case 1:
					echo '<dd>';
						if ($item->ville && $params->get('show_suburb',1)) : ?>
							<span class="gmapfp-ville" itemprop="addressLocality">
								<?php echo $item->ville; ?>
							</span>
						<?php endif;
						if ($item->codepostal && $params->get('show_postcode',1)) : ?>
							<span class="gmapfp-codepostal" itemprop="postalCode">
								<?php echo $item->codepostal; ?>
							</span>
						<?php endif;
					echo '</dd>';
					break;
				case 2:
					if ($item->ville && $params->get('show_suburb',1)) : ?>
						<dd class="gmapfp-ville" itemprop="addressLocality">
							<?php echo $item->ville; ?>
						</dd>
					<?php endif;
					if ($item->codepostal && $params->get('show_postcode',1)) : ?>
						<dd class="gmapfp-codepostal" itemprop="postalCode">
							<?php echo $item->codepostal; ?>
						</dd>
					<?php endif;
					break;
				case 3:
					if ($item->codepostal && $params->get('show_postcode',1)) : ?>
						<dd class="gmapfp-codepostal" itemprop="postalCode">
							<?php echo $item->codepostal; ?>
						</dd>
					<?php endif;
					if ($item->ville && $params->get('show_suburb',1)) : ?>
						<dd class="gmapfp-ville" itemprop="addressLocality">
							<?php echo $item->ville; ?>
						</dd>
					<?php endif;
					break;
			}
			if ($item->departement && $params->get('show_state',1)) : ?>
					<dd class="gmapfp-departement" itemprop="addressRegion">
						<?php echo $item->departement; ?>
					</dd>
			<?php endif;
			if ($item->pays && $params->get('show_country',1)) : ?>
					<dd class="gmapfp-pays" itemprop="addressCountry">
						<?php echo $item->pays; ?>
					</dd>
			<?php endif;
		?>
	<?php endif; ?>

</dl>
