<?php
	/*
	* GMapFP Component Google Map for Joomla! 4.0.x
	* Version J4_0_12F
	* Creation date: Novembre 2023
	* Author: Fabrice4821 - www.gmapfp.org
	* Author email: support@gmapfp.org
	* License GNU/GPL
	*/

defined('_JEXEC') or die;

use Joomla\CMS\Factory;
use Joomla\CMS\HTML\HTMLHelper;
use Joomla\CMS\Language\Associations;
use Joomla\CMS\Language\Text;
use Joomla\CMS\Layout\FileLayout;
use Joomla\CMS\Layout\LayoutHelper;
use Joomla\CMS\Router\Route;
use Joomla\CMS\Uri\Uri;
use Joomla\Component\Gmapfp\Administrator\Extension\GmapfpComponent;
use Joomla\Component\Gmapfp\Site\Helper\RouteHelper as GmapfpRoute;

// Create shortcuts to some parameters.
$params  = $this->item->params;
$images  = json_decode($this->item->img);
$canEdit = $params->get('access-edit');
$user    = Factory::getUser();
$info    = $params->get('info_block_position', 0);

// Check if associations are implemented. If they are, define the parameter.
$assocParam = (Associations::isEnabled() && $params->get('show_associations'));
?>
<div class="com-gmapfp-item item-page<?php echo $this->pageclass_sfx; ?>" itemscope itemtype="https://schema.org/Article">
	<meta itemprop="inLanguage" content="<?php echo ($this->item->language === '*') ? Factory::getApplication()->get('language') : $this->item->language; ?>">
	<?php if ($this->params->get('show_page_heading')) : ?>
		<div class="page-header">
			<h1> <?php echo $this->escape($this->params->get('page_heading')); ?> </h1>
		</div>
	<?php endif;?>

	<?php // Todo Not that elegant would be nice to group the params?>
	<?php $useDefList = ($params->get('show_modify_date',1) || $params->get('show_publish_date',1) || $params->get('show_create_date',1)
	|| $params->get('show_hits',1) || $params->get('show_category',1) || $params->get('show_parent_category',1) || $params->get('show_author',1) || $assocParam); ?>

	<?php if ($params->get('show_title',1) || $canEdit || $params->get('show_map_form', 1) || $params->get('show_hp_form', 1) || $params->get('show_email_form', 1)) : ?>
		<div class="page-header">
			<?php echo LayoutHelper::render('blog_style_default_item_title', $this->item); ?>

			<?php if ($canEdit) : ?>
				<?php echo LayoutHelper::render('icons', array('params' => $params, 'item' => $this->item)); ?>
			<?php endif; ?>
		</div>
	<?php endif; ?>

	<?php // Content is generated by content plugin event "onContentAfterTitle" ?>
	<?php echo $this->item->event->afterDisplayTitle; ?>

	<?php if ($useDefList && ($info == 0 || $info == 2)) : ?>
		<?php echo LayoutHelper::render('info_block', array('item' => $this->item, 'params' => $params, 'position' => 'above')); ?>
	<?php endif; ?>

	<?php if ($info == 0 && $params->get('show_tags', 1) && !empty($this->item->tags->itemTags)) : ?>
		<?php $this->item->tagLayout = new FileLayout('joomla.content.tags'); ?>
		<?php echo $this->item->tagLayout->render($this->item->tags->itemTags); ?>
	<?php endif; ?>

	<?php // Content is generated by content plugin event "onContentBeforeDisplay" ?>
	<?php echo $this->item->event->beforeDisplayContent; ?>

	<?php if ($params->get('access-view')) : ?>
		<?php if ($this->params->get('show_gmapfp_email_form', 0) == 1 and $this->item->email) : ?>
			<?php echo '<iframe id="gmapfp_email_form" title="gmapfp_email_form" height="'.$this->params->get('gmapfp_hauteur_lightbox_email_form', 700).'px" width="100%" src="index.php?option=com_gmapfp&view=email&tmpl=component&id='.$this->item->id.'"></iframe>'; ?>
		<?php endif; ?>
        <?php echo $this->loadTemplate('content'); ?>
		<?php if ($this->params->get('show_gmapfp_email_form', 0) == 2 and $this->item->email) : ?>
			<?php echo '<iframe id="gmapfp_email_form" title="gmapfp_email_form" height="'.$this->params->get('gmapfp_hauteur_lightbox_email_form', 700).'px" width="100%" src="index.php?option=com_gmapfp&view=email&tmpl=component&id='.$this->item->id.'"></iframe>'; ?>
		<?php endif; ?>
		<?php if ($info == 1 || $info == 2) : ?>
			<?php if ($useDefList) : ?>
				<?php echo LayoutHelper::render('info_block', array('item' => $this->item, 'params' => $params, 'position' => 'below')); ?>
			<?php endif; ?>
			<?php if ($params->get('show_tags', 1) && !empty($this->item->tags->itemTags)) : ?>
				<?php $this->item->tagLayout = new FileLayout('joomla.content.tags'); ?>
				<?php echo $this->item->tagLayout->render($this->item->tags->itemTags); ?>
			<?php endif; ?>
		<?php endif; ?>

		<?php if ($params->get('show_readmore',1) && isset($this->item->readmore) && $this->item->readmore) :
			if ($params->get('access-view')) :
				$link = Route::_(GmapfpRoute::getItemRoute($this->item->slug, $this->item->catid, $this->item->language));
			else :
				$menu = Factory::getApplication()->getMenu();
				$active = $menu->getActive();
				$itemId = $active->id;
				$link = new Uri(Route::_('index.php?option=com_users&view=login&Itemid=' . $itemId, false));
				$link->setVar('return', base64_encode(GmapfpRoute::getItemRoute($this->item->slug, $this->item->catid, $this->item->language)));
			endif; ?>
			<?php echo LayoutHelper::render('readmore', array('item' => $this->item, 'params' => $params, 'link' => $link)); ?>
		<?php endif; ?>
	<?php // Optional teaser intro text for guests ?>
	<?php elseif ($params->get('show_noauth') == true && $user->get('guest')) : ?>
		<div class="row com-gmapfp-item__intro">
			<?php if ($params->get('show_image', 1)) : ?>
				<?php echo LayoutHelper::render('image', array('item' => $this->item, 'params' => $params, 'width' => $params->get('gmapfp_largeur_img_art', 5))); ?>
			<?php endif; ?>
			<?php echo LayoutHelper::render('adresse', array('item' => $this->item, 'params' => $params, 'width' => 4)); ?>
		</div>
		<?php echo HTMLHelper::_('content.prepare', $this->item->introtext); ?>
		<?php // Optional link to let them register to see the whole article. ?>
		<?php if ($params->get('show_readmore',1) && $this->item->fulltext != null) : ?>
			<?php $menu = Factory::getApplication()->getMenu(); ?>
			<?php $active = $menu->getActive(); ?>
			<?php $itemId = $active->id; ?>
			<?php $link = new Uri(Route::_('index.php?option=com_users&view=login&Itemid=' . $itemId, false)); ?>
			<?php $link->setVar('return', base64_encode(GmapfpRoute::getItemRoute($this->item->slug, $this->item->catid, $this->item->language))); ?>
			<p class="com-gmapfp-item__readmore readmore">
				<a href="<?php echo $link; ?>" class="register">
				<?php 
					$attribs = json_decode($this->item->attribs);
					$attribs = new stdclass();
					$attribs->alternative_readmore = 1;
					if ($attribs->alternative_readmore == null) :
						echo Text::_('COM_GMAPFP_REGISTER_TO_READ_MORE');
					elseif ($readmore = $attribs->alternative_readmore) :
						echo $readmore;
						if ($params->get('show_readmore_title',1) != 0) :
							echo HTMLHelper::_('string.truncate', $this->item->title, $params->get('readmore_limit',100));
						endif;
					elseif ($params->get('show_readmore_title',1) == 0) :
						echo Text::sprintf('COM_GMAPFP_READ_MORE_TITLE');
					else :
						echo Text::_('COM_GMAPFP_READ_MORE');
						echo HTMLHelper::_('string.truncate', $this->item->title, $params->get('readmore_limit',100));
					endif; 
				?>
				</a>
			</p>
		<?php endif; ?>
	<?php endif; ?>
	<?php
	if (!empty($this->item->pagination) && $this->item->pagination && $this->item->paginationposition && $this->item->paginationrelative) :
		echo $this->item->pagination;
	?>
	<?php endif; ?>
	<?php // Content is generated by content plugin event "onContentAfterDisplay" ?>
	<?php echo $this->item->event->afterDisplayContent; ?>
</div>
