<?php
	/*
	* GMapFP Component Google Mto for Joomla! 3.x
	* Version J3_3
	* Creation date: Janvier 2017
	* Author: Fabrice4821 - www.gmapfp.org
	* Author email: webmaster@gmapfp.org
	* License GNU/GPL
	*/

defined( '_JEXEC' ) or die;

require_once (dirname(__FILE__).'/helper_'.$params->get( 'meteo_api','Yahoo').'.php');

// dtecte langue
jimport( 'joomla.language.helper' );
$lang = JLanguageHelper::detectLanguage();
$lang = substr($lang,0,2);

//die(print_r($attribs));
//die(print_r($params));
//die(print_r($module));
$document = JFactory::getDocument();
$document->addStyleSheet( JURI::Base(false).'modules/mod_meteofp/tmpl_'.$params->get( 'meteo_api','yahoo').'/'.$params->get( 'template','standard').'/style.css', 'text/css' );

$output = "<form id='MeteoFP_".$module->id."' name='MeteoFP_".$module->id."' method=get class='mod_meteofp".$params->get( 'moduleclass_sfx' )."'>\n";

if ($params->get('temp_unit') == 'f') { $temp_unit = 'f'; } else { $temp_unit = 'c'; };
if ($params->get('meteo_api','Yahoo') == 'Yahoo') {
	$meteo = new Yahoo_WeatherAPI($params->get('woeid', 615134), $temp_unit, $params->get('cache'), $params->get('cache_time'));
} else {
	$meteo = new Google_WeatherAPI($params->get('lieu'), $lang, $temp_unit, $params->get('cache'), $params->get('cache_time'));
}
	
if ($meteo->isfound()) {
	$icon_path = JURI::Base(false)."modules/mod_meteofp/icons/";
	$actuelle = $meteo->getCurrent();
		//die(print_r($actuelle));

	// add automatic margin to image to beauty outputs without stylesheets
	$img_margin = "5px 0";
	if ($params->get('img_align')=="left") { $img_margin = "0 10px 5px 0";  }
	if ($params->get('img_align')=="right") { $img_margin = "0 0 5px 10px";  }

	$now = date('');
	if ($params->get('afficher_date', 0)) $output .=  "<div class='meteofp_date'><h4>".JHtml::date( $now, JText::_($params->get('afficher_date')))."</h4></div>";
	if ($params->get('afficher_ville', 1)) $output .=  "<div class='meteofp_city'><h4>".$meteo->getCity()."</h4></div>";

 	if ($actuelle) {
		if ($params->get( 'meteo_api','Yahoo') == 'Yahoo') {
			switch ($params->get('temp_unit')) {
				case 'c':
					$tmp_actuelle = $actuelle['temp']."&nbsp;&deg;C";
					$unit = "C";
				break;
				case 'f':
					$tmp_actuelle = $actuelle['temp']."&nbsp;&deg;F";
					$unit = "F";
				break;
				default:
					if ($meteo->getUnit_system() == 'C') {
						$tmp_actuelle = "(&nbsp;".round(($actuelle['temp']*9/5)+32)."&nbsp;&deg;F&nbsp;/&nbsp;";
						$tmp_actuelle .= $actuelle['temp']."&nbsp;&deg;C&nbsp;)";
						$unit = false;
					} else {
						$tmp_actuelle = "(&nbsp;".$actuelle['temp']."&nbsp;&deg;F&nbsp;/&nbsp;";
						$tmp_actuelle .= round(($actuelle['temp']-32)*5/9)."&nbsp;&deg;C&nbsp;)";
						$unit = false;
					}
				}
		} else {
			switch ($params->get('temp_unit')) {
				case 'c':
					$tmp_actuelle = $actuelle['temp_c']."&nbsp;&deg;C";
					$unit = "C";
				break;
				case 'f':
					$tmp_actuelle = $actuelle['temp_f']."&nbsp;&deg;F";
					$unit = "F";
				break;
				default:
					$tmp_actuelle = "(&nbsp;".$actuelle['temp_f']."&nbsp;&deg;F&nbsp;/&nbsp;";
					$tmp_actuelle .= $actuelle['temp_c']."&nbsp;&deg;C&nbsp;)";
					$unit = false;
				}
		}

		$output .= include dirname(__FILE__).'/tmpl_'.$params->get( 'meteo_api','yahoo').'/'.$params->get( 'template','standard').'/actuelle.php';
		
		// output prvisions
		if ($params->get( 'meteo_previsions',1)) {
			$previsions = $meteo->getForecast();
			$unit_system = $meteo->getUnit_system();
			if (!$unit) $unit = ($unit_system=="US") ? "F" : "C";
			
			$output .= include dirname(__FILE__).'/tmpl_'.$params->get( 'meteo_api','yahoo').'/'.$params->get( 'template','standard').'/previsions.php';
		}
		
	} else {
		if ($params->get('icon') != -1) {
			$output .= "<img class='meteofp_img' src='".$icon_path."warning.png' alt='error' align='".$params->get('img_align')."' style='margin:".$img_margin.";' />";
		}
		$output .= "<p>".JText::_("MOD_METEOFP_NOT_INFO").$params->get('lieu')."</p>\n";
	}

} else {
	$output .=JText::_("MOD_METEOFP_VILLE_NON_TROUVEE");
}
$output .= "</form>\n";
	
echo $output;
?>
