<?php
	/*
	* ContactMap Component Google Map for Joomla! 3.x
	* Version J3.19F
	* Creation date: Janvier 2018
	* Author: Fabrice4821 - www.gmapfp.org
	* Author email: webmaster@gmapfp.org
	* License GNU/GPL
	*/

defined('JPATH_BASE') or die;

class PlgSystemContactMap extends JPlugin
{
	public function onAfterDispatch()
	{
		$language 	= JFactory::getLanguage();
		$language->load('com_contactmap');
		// Set the variables
		$input = JFactory::getApplication()->input;
		$extension 	= $input->get('option', '', 'cmd');
		$view 		= $input->get('view', '', 'cmd');
		$layout 	= $input->get('layout', '', 'cmd');
		$format     = $input->get('format', '', 'cmd');
		$id 		= $input->get('id', '', 'int');
		
// ******** Partie frontend *******
		if (JFactory::getApplication()->isSite())
		{
			$params = JComponentHelper::getParams('com_contact');
			$params_2 = JComponentHelper::getParams('com_contactmap');
			
			if ($extension != "com_contact" or $view != "contact" or ($format and $format != 'html'))
				return true;
			
			// Adjust the component buffer.
			$doc = JFactory::getDocument();
			$buf = $doc->getBuffer('component');
			
			$dom = new DOMDocument();
			@$dom->loadHTML($buf);
				
			$lignes_buf = explode("\n", $buf);
			
			$xpath = new DOMXPath($dom);
			
			if ($id) {
				$contact_id = $id;
			} else {
				$contact_id = $xpath->query('//div[@class="form-actions"]/input[@name="id"]');
				$contact_id =(int)$contact_id->item(0)->getAttribute('value');
			}
			
			$query = $xpath->query('//div[@id="basic-details"]');

			$return =array();
			foreach($query as $node)
			{
				$out = new DOMDocument();
				$inner = $out->importNode($node, true);
				$out->appendChild($inner);
				$return[] = $out->saveHTML();
			}

			$last = count($return)-1;
			
			if($last < 0) 
				$lignes_last = "";
			else
				$lignes_last = explode("\n", trim($return[$last]));
			
			for ($i = 0; $i<= count($lignes_buf); $i++) 
			{
				if (@strpos(trim($lignes_buf[$i]), trim($lignes_last[0]))!==false) break;
			}
			
			function find_div($ligne, $index, $cn)
			{
				$pos = 0;
				$deb = strpos($ligne, '<div', $index);
				$fin = strpos($ligne, '</div', $index);
				if ($deb!==false or $fin!==false) {
					if ($deb!==false and $fin!==false and $deb < $fin) {
						$cn++;
						$tmp = find_div($ligne, $deb + 1, $cn);
						$cn = $tmp[0];
						$pos = $tmp[1];
					}
					if ($deb!==false and $fin!==false and $deb > $fin) {
						$cn--;
						if (! $cn) return array($cn, $fin);
						$tmp = find_div($ligne, $fin + 1, $cn);
						$cn = $tmp[0];
						$pos = $tmp[1];
					}
					if ($deb!==false and ! $fin!==false) {
						$cn++;
						$tmp = find_div($ligne, $deb + 1, $cn);
						$cn = $tmp[0];
						$pos = $tmp[1];
					}
					if (!$deb!==false and $fin!==false) {
						$cn--;
						if (! $cn) return array($cn, $fin);
						$tmp = find_div($ligne, $fin + 1, $cn);
						$cn = $tmp[0];
						$pos = $tmp[1];
					}
				}
				return array($cn, $pos);
			}
			
			$end = false;
			$cn_div = array(0, 0);
			//trouve la fin de la <div
			while (! $end){
				if ($i > count($lignes_buf)-1) break;
				$cn_div = find_div($lignes_buf[$i], 0, $cn_div[0]);
				if ($cn_div[0] == 0) break;
				$i++;
			}

			// Recherche la fin de div suivante
			$index_fin_div = 0;
			$decal_div = $params_2->get('decalage_div', 0);
			for ($cnb = 0; $cnb <= $decal_div; $cnb++) {
				while (!$end) {
					if ($i > count($lignes_buf)-1) break;
					if (strpos($lignes_buf[$i], '</div>', $cn_div[1]+$index_fin_div)!==false) {
						$index_fin_div = strpos($lignes_buf[$i], '</div>', $cn_div[1]+$index_fin_div)+6;
						$cn_div[1] = 0;
						break;
					}
					$i++;
					$cn_div[1] = 0;
					$index_fin_div = 0;
				}
			}
		
			$debut = array_slice($lignes_buf, 0, $i);
			$debut = implode("\n", $debut);
			$fin = array_slice($lignes_buf, $i+1);
			$fin = implode("\n", $fin);
			
			$ligne_insert = array_slice($lignes_buf, $i, 1);
			$lenght = @strlen($ligne_insert[0]);
			
			$deb_insert = @substr($ligne_insert[0], 0, $cn_div[1]+$index_fin_div);
			$fin_insert = @substr($ligne_insert[0], $cn_div[1]+$index_fin_div, $lenght);

			$hack = '';
			if ($params->get('presentation_style') == 'sliders') :
				$hack .= JHtml::_('bootstrap.addSlide', 'slide-contact', JText::_('COM_CONTACTMAP_MAP'), 'display-map');
			endif;
			if ($params->get('presentation_style') == 'tabs') :
				$hack .= JHtml::_('bootstrap.addTab', 'myTab', 'display-map', JText::_('COM_CONTACTMAP_MAP', true));
			endif;
			if ($params->get('presentation_style') == 'plain'):
				$hack .= '<h3>'. JText::_('COM_CONTACTMAP_MAP').'</h3>';
			endif;
			
			include(JPATH_SITE.'/components/com_contactmap/models/contactmap.php');
			$model = new ContactMapsModelContactMap;
			$model->setId($contact_id);
			$result = $model->getView();
			if ($result) {
				$hack .= $model->getView();

				if ($params->get('presentation_style') == 'sliders') :
					$hack .= JHtml::_('bootstrap.endSlide');
				endif;
				if ($params->get('presentation_style') == 'tabs') :
					$hack .= JHtml::_('bootstrap.endTab');
				endif;

				$doc->setBuffer($debut.$deb_insert.$hack.$fin_insert.$fin, 'component');
			}
			return true;
		}

// ******** Partie backend *******
		
		if ($extension != "com_contact" or $view != "contact" or $layout != "edit")
			return true;

		JHtml::_('behavior.modal', 'a.modal_jform_user_id');
			
		// Load language
		$this->loadLanguage();

		// Adjust the component buffer.
		$doc = JFactory::getDocument();
		$buf = $doc->getBuffer('component');
		
		$pos = strpos($buf, '<div class="control-group"><div class="control-label"><label id="jform_featured-lbl"');
		$debut = substr($buf, 0, $pos);
		$fin = substr($buf, $pos);

		$srcipt = '
			<script type="text/javascript">
				window.addEvent(\'domready\', function() {
					var tmp = jQuery(\'#contact-form\').attr(\'action\');
					var debut = tmp.lastIndexOf("=") + 1;
					var id = tmp.substr(debut, tmp.length);
					var link = "index.php?option=com_contactmap&view=map&layout=modal&tmpl=component&id=" + id;
					jQuery(\'#bp_contact_map_go\').attr(\'href\', link);
				});
			</script>
		';
		$machaine = '
			<div class="control-group">
				<div class="control-label">
					<label id="jform_language-lbl" for="jform_language" class="hasTooltip" title="<strong>'.JText::_('PLG_SYSTEM_CONTACTMAP_GEOLOCALISER_LABEL').'</strong><br />'.JText::_('PLG_SYSTEM_CONTACTMAP_GEOLOCALISER_DESC').'">
						'.JText::_('PLG_SYSTEM_CONTACTMAP_GEOLOCALISER_LABEL').'
					</label>
				</div>
				<div class="controls">
					<a class="btn btn-primary modal_jform_user_id" id="bp_contact_map_go"
						onclick="SqueezeBox.fromElement(this, {handler:\'iframe\', size: {x: 800, y: 500}, url:\'index.php?option=com_contactmap&amp;view=map&amp;layout=modal&amp;tmpl=component\'})">
						<i class="icon-location"></i>
						'.JText::_('PLG_SYSTEM_CONTACTMAP_GEOLOCALISER_TROUVER_LABEL').'
					</a>				
				</div>
			</div>
		
		';
		$buf = $srcipt.$debut.$machaine.$fin;
		$doc->setBuffer($buf, 'component');

		return true;
	}
}
